<?php
	header("Content-Type: text/text; charset=utf-8");	
	
// Функция для генерации всех перестановок
function generatePermutations($items, $perms = []) {
    if (empty($items)) {
        // Когда перестановка завершена, возвращаем результат
        yield $perms;
    } else {
        for ($i = 0; $i < count($items); $i++) {
            $newItems = $items;
            $newPerms = $perms;
            array_push($newPerms, $newItems[$i]);
            array_splice($newItems, $i, 1);
            yield from generatePermutations($newItems, $newPerms);
        }
    }
}

// Функция для заполнения 3x3 массива перестановкой, с фиксированным значением 24 в (0,0)
function fillArray3x3($permutation) {
    $array = [];
    $array[0][0] = 24; // Фиксируем значение в ячейке (0,0)
    
    $index = 0;
    for ($i = 0; $i < 3; $i++) {
        for ($j = 0; $j < 3; $j++) {
            if ($i == 0 && $j == 0) continue; // Пропускаем ячейку (0,0)
            $array[$i][$j] = $permutation[$index++];
        }
    }
    
    if (
    	$array[0][0] / $array[1][0] + $array[2][0] == 13
    	&& $array[0][1] + $array[1][1] - $array[2][1] == 15
    	&& $array[0][2] * $array[1][2] / $array[2][2] == 10
    	
	    && $array[0][0] / $array[0][1] * $array[0][2] == 15
	    && $array[1][0] * $array[1][1] / $array[1][2] == 6
	    && $array[2][0] + $array[2][1] * $array[2][2] == 13
    	) {
	    
		print_r($array);

//	    die();
    }
    
    return $array;
}

// Генерируем все перестановки чисел от 2 до 9
$numbers = range(2, 9);

// Перебираем все возможные перестановки
foreach (generatePermutations($numbers) as $permutation) {
    $array3x3 = fillArray3x3($permutation);
    
    // Выводим текущий вариант заполненного массива 3x3
    foreach ($array3x3 as $row) {
//        echo implode(" ", $row) . "\n";
    }
}
    echo "OK!\n"; // Разделяем вывод массивов новой строкой
?>