<?php

ini_set('show_errors', 1);
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once("/home/oaapps/domains/apps.orderadmin.eu/public_html/br/db_config.php");
require $_SERVER['DOCUMENT_ROOT'].'/br/vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$date_from   = $_REQUEST['date_from'] ?? '2026-01-01';
$filter_code = $_REQUEST['filter_code'] ?? ''; // список of_br_id через запятую (без кавычек)
$curTime     = time();

// --------------------------------------------------
// Excel
// --------------------------------------------------
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();
$sheet->getPageMargins()->setLeft(1)->setRight(1)->setTop(1)->setBottom(1);

$sheet->getRowDimension('1')->setRowHeight(30);
$sheet->getStyle('A1:H1')->getFont()->setBold(true);

foreach (range('A','H') as $col) {
    $sheet->getStyle($col.'1')->getFill()
        ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
        ->getStartColor()->setARGB('#faff88');
}

$sheet->getColumnDimension('A')->setWidth(12); // дата
$sheet->getColumnDimension('B')->setWidth(25); // магазин
$sheet->getColumnDimension('C')->setWidth(14); // код
$sheet->getColumnDimension('D')->setWidth(55); // товар
$sheet->getColumnDimension('E')->setWidth(14); // picked
$sheet->getColumnDimension('F')->setWidth(14); // received
$sheet->getColumnDimension('G')->setWidth(14); // diff
$sheet->getColumnDimension('H')->setWidth(14); // expected

$sheet->setCellValue('A1', 'Дата');
$sheet->setCellValue('B1', 'Магазин');
$sheet->setCellValue('C1', 'Код');
$sheet->setCellValue('D1', 'Товар');
$sheet->setCellValue('E1', 'Picked');
$sheet->setCellValue('F1', 'Received');
$sheet->setCellValue('G1', 'Diff');
$sheet->setCellValue('H1', 'Expected');

// --------------------------------------------------
// SQL filter
// --------------------------------------------------
$SQL = '';
if (strlen(trim($filter_code)) > 0) {
    // как у тебя: прямое IN (...)
    $SQL = ' AND o.ao_id_offer_code IN ('.$filter_code.')';
}

$date_from_sql = $GLOBALS['mysql_link']->real_escape_string($date_from);

// --------------------------------------------------
// Query
// --------------------------------------------------
$query = "
SELECT
    a.ac_shop_id,
    a.ac_doc_date,

    s.sh_name AS shop_name,

    o.ao_id_offer_code,
    o.ao_count_picked,
    o.ao_count_received,
    o.ao_count_expected,

    ofr.of_name

FROM br_acceptance a
JOIN br_acceptance_offers o ON a.ac_id = o.ao_id_acceptance
LEFT JOIN br_offers ofr ON ofr.of_br_id = o.ao_id_offer_code
LEFT JOIN br_shops s ON s.sh_id = a.ac_shop_id

WHERE a.ac_status LIKE 'COMPLETED'
  AND a.ac_doc_date >= '".$date_from_sql."'
  AND ROUND(o.ao_count_picked, 6) <> ROUND(o.ao_count_received, 6)
  ".$SQL."
ORDER BY a.ac_doc_date DESC, a.ac_id DESC, o.ao_id ASC
";

$mysql_res = $GLOBALS['mysql_link']->query($query);
if (!$mysql_res) {
    echo "<pre style='color:#a30000;'>SQL error: ".$GLOBALS['mysql_link']->error."\n\n".$query."</pre>";
    die();
}

?>
<h2 style="color:#A30000">Расхождения по приёмкам (picked != received)</h2>

<style>
  .sticky-header th { position: sticky; top: 0; background-color: #fff; }
</style>

<div style="background-color:#b5f6ff; border:#7ab7ff dotted 2px; padding:15px 15px 0px 15px;">
  <form action="" method="POST">
    <table>
      <tr>
        <td><b>Дата от:</b></td>
        <td><input type="date" name="date_from" value="<?=htmlspecialchars($date_from)?>" /></td>

        <td style="padding-left:15px;"><b>Фильтр по артикулам:</b></td>
        <td>
          <textarea name="filter_code" id="filter_code" rows="2" style="width:700px;"><?=htmlspecialchars($filter_code)?></textarea>
        </td>

        <td style="padding-left:15px;">
          <input type="submit" value="Фильтровать">
        </td>
      </tr>

      <tr>
        <td></td>
        <td colspan="4">
          <i style="font-size:13px;">
            Укажите коды товаров через запятую (без кавычек). Если пусто — покажет все расхождения с указанной даты.
          </i>
        </td>
      </tr>
    </table>
  </form>
</div>

<hr>

<div align="right">
  <a href="/br/cron/files/acceptance_diff_<?=$curTime?>.xlsx">Скачать результаты</a>
</div>
<br>

<table border="0" cellpadding="10" cellspacing="1" width="100%" class="sticky-header">
<thead>
<tr>
  <th style="background-color:#585454; color:#FFFFFF;">#</th>
  <th style="background-color:#585454; color:#FFFFFF;">Дата</th>
  <th style="background-color:#585454; color:#FFFFFF;">Магазин</th>
  <th style="background-color:#585454; color:#FFFFFF;">Код</th>
  <th style="background-color:#585454; color:#FFFFFF;">Товар</th>
  <th style="background-color:#585454; color:#FFFFFF;">Подобрано</th>
  <th style="background-color:#585454; color:#FFFFFF;">Принято</th>
  <th style="background-color:#585454; color:#FFFFFF;">Разница</th>
  <th style="background-color:#585454; color:#FFFFFF;">Заказано</th>
</tr>
</thead>
<tbody>
<?php

$num = 0;
$excelRow = 2;

while ($row = mysqli_fetch_assoc($mysql_res)) {

    $num++;

    $picked   = (float)$row['ao_count_picked'];
    $received = (float)$row['ao_count_received'];
    $expected = (float)$row['ao_count_expected'];
    $diff     = $picked - $received;

    // Подсветка расхождения
    $abs = abs($diff);
    $bg = '#d5fcff';
    if ($abs > 0.000001) $bg = '#ffdce0';
    if ($abs > 0.01)     $bg = '#ffb7c6';

    $offerCode = $row['ao_id_offer_code'];
    $offerName = $row['of_name'] ?? '(товар не найден в br_offers)';
    $shopName  = $row['shop_name'] ?? ('shop_id='.$row['ac_shop_id']);

	if ($diff < 0)  $bg = '#b7ffc6';

    echo '<tr>
        <td style="background-color:#FFFFFF; border-bottom:1px dotted #9b9b9b;">'.$num.'</td>
        <td style="background-color:#FFFFFF; border-bottom:1px dotted #9b9b9b;">'.$row['ac_doc_date'].'</td>
        <td style="background-color:#FFFFFF; border-bottom:1px dotted #9b9b9b;">'.htmlspecialchars($shopName).'</td>
        <td style="background-color:#FFFFFF; border-bottom:1px dotted #9b9b9b;">'.$offerCode.'</td>
        <td style="background-color:#FFFFFF; border-bottom:1px dotted #9b9b9b;">'.htmlspecialchars($offerName).'</td>
        <td style="background-color:#FFFFFF; border-bottom:1px dotted #9b9b9b;">'.str_replace('.', ',', $picked).'</td>
        <td style="background-color:#FFFFFF; border-bottom:1px dotted #9b9b9b;">'.str_replace('.', ',', $received).'</td>
        <td style="background-color:'.$bg.'; border-bottom:1px dotted #9b9b9b;">'.str_replace('.', ',', $diff).'</td>
        <td style="background-color:#FFFFFF; border-bottom:1px dotted #9b9b9b;">'.str_replace('.', ',', $expected).'</td>
    </tr>';

    // Excel
    $sheet->setCellValue('A'.$excelRow, $row['ac_doc_date']);
    $sheet->setCellValue('B'.$excelRow, $shopName);
    $sheet->setCellValue('C'.$excelRow, $offerCode);
    $sheet->setCellValue('D'.$excelRow, $offerName);
    $sheet->setCellValue('E'.$excelRow, $picked);
    $sheet->setCellValue('F'.$excelRow, $received);
    $sheet->setCellValue('G'.$excelRow, $diff);
    $sheet->setCellValue('H'.$excelRow, $expected);

    $excelRow++;
}

if ($num == 0) {
    echo '<tr><td colspan="9" align="center" style="background-color:#e7e2ef;">
        <i>Расхождений не найдено по выбранным условиям.</i>
    </td></tr>';
}

echo '</tbody></table>';

// --------------------------------------------------
// Save XLSX
// --------------------------------------------------
$writer = new Xlsx($spreadsheet);
$writer->save($_SERVER['DOCUMENT_ROOT'].'/br/cron/files/acceptance_diff_'.$curTime.'.xlsx');

?>
