<?php
	
	$_SERVER['DOCUMENT_ROOT'] = '/home/oaapps/domains/apps.orderadmin.eu/public_html';

	require_once($_SERVER['DOCUMENT_ROOT']."/br/db_config.php");	
	require $_SERVER['DOCUMENT_ROOT'].'/br/vendor/autoload.php';

	use PhpOffice\PhpSpreadsheet\Spreadsheet;
	use PhpOffice\PhpSpreadsheet\Writer\Xlsx;   
	
	$t_date = date('Y-m-d', time());

	$num = 1;

	//Создаем экземпляр класса электронной таблицы
	$spreadsheet = new Spreadsheet();
	//Получаем текущий активный лист
	$sheet = $spreadsheet->getActiveSheet();
	$sheet->getPageMargins()
	    ->setLeft(1)
	    ->setRight(1)
	    ->setTop(1)
	    ->setBottom(1)
	;

	$sheet->getColumnDimension('A')->setWidth(10);
	$sheet->getRowDimension('1')->setRowHeight(30);

	$sheet->getColumnDimension('B')->setWidth(50);
	$sheet->getColumnDimension('R')->setWidth(50);

	$sheet->getStyle('A1:R1')->getFont()->setBold(true);

	$sheet->getStyle('A1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#faff88');
	$sheet->getStyle('B1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#faff88');
	$sheet->getStyle('C1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#faff88');
	$sheet->getStyle('D1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#faff88');
	$sheet->getStyle('E1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#faff88');
	$sheet->getStyle('F1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#faff88');
	$sheet->getStyle('G1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#faff88');

	$sheet->getStyle('H1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#7bd673');
	$sheet->getStyle('I1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#7bd673');
	$sheet->getStyle('J1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#7bd673');
	$sheet->getStyle('K1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#7bd673');

	$sheet->getStyle('L1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#6bb0ff');

	$sheet->getStyle('M1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#7bd673');
	$sheet->getStyle('N1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#faff88');

	// Записываем в ячейку A1 данные
	$sheet->setCellValue('A'.$num, 'Код');
	$sheet->setCellValue('B'.$num, 'Товар');

	$sheet->setCellValue('C'.$num, 'Ед. изм.');
	$sheet->setCellValue('D'.$num, 'Приходная цена');
	$sheet->setCellValue('E'.$num, 'Розничная цена');
	$sheet->setCellValue('F'.$num, 'Маржа %');	
	$sheet->setCellValue('G'.$num, 'Нал склада');
	
	$sheet->setCellValue('H'.$num, 'Продажи склада за 4 нед. ');
	$sheet->setCellValue('I'.$num, 'Нал магазинов (общая)');
	$sheet->setCellValue('J'.$num, 'Продажи магазинов (общие) за 4 недели');
	$sheet->setCellValue('K'.$num, 'В каком количестве магазинов есть каждый артикул');
	$sheet->setCellValue('L'.$num, 'Категория');
	
	$ar_categ = [];
	
	$mysql_res = $GLOBALS['mysql_link'] -> query('SELECT * FROM br_groups;');	
	
	while ($row = mysqli_fetch_assoc($mysql_res)) {
		
		$code = $row['gr_code'];
		$name = $row['gr_name'];

		$ar_categ[$code] = $name;

	}

	$mysql_res = $GLOBALS['mysql_link'] -> query('SELECT st_good_id, of_br_id, of_name, of_unit, gr_code, SUM(st_qtty), SUM(st_price), of_price_in, of_price_out, of_producer 
			FROM br_store, br_offers, br_groups 
				WHERE 
					st_good_id = of_mi_id 
					AND of_group_id = gr_id 
					AND st_date = "'.$t_date.'" 
					AND of_deleted = 0 
						
					GROUP BY st_good_id ORDER BY SUM(st_qtty) DESC LIMIT 0, 100000;');	

	while ($row = mysqli_fetch_assoc($mysql_res)) {
		
		$num++;
		
		$categ_code = '';
		
		$offer_id = $row['st_good_id'];
		$offer_code = $row['of_br_id'];
		$offer_name = $row['of_name'];
		$offer_unit = $row['of_unit'];
		$categ_code = $row['gr_code'];
		$offer_count = $row['SUM(st_qtty)'];
		$price_in = $row['of_price_in'];
		$price_out = $row['of_price_out'];
		$offer_producer = $row['of_producer'];
		
		if (strlen($categ_code) == 9) $categ_name = $ar_categ[substr($categ_code, 0, 3)].' / '.$ar_categ[substr($categ_code, 0, 6)].' / '.$ar_categ[substr($categ_code, 0, 9)];
		if (strlen($categ_code) == 6) $categ_name = $ar_categ[substr($categ_code, 0, 3)].' / '.$ar_categ[substr($categ_code, 0, 6)];
		if (strlen($categ_code) == 3) $categ_name = $ar_categ[$categ_code];
		
		if ($price_in == 0 || $price_out == 0) {
				
			$mysql_res2 = $GLOBALS['mysql_link'] -> query('SELECT * FROM `br_operations` WHERE `op_good_id` = "'.$offer_id.'" AND `op_discount` = 0 AND `op_operation_type` = 2 ORDER BY op_user_real_time DESC LIMIT 0, 1;');			
			$marga = 0;
			
			if ($row2 = mysqli_fetch_assoc($mysql_res2)) {
				
				$price_in = $row2['op_price_in'];
				$price_out = $row2['op_price_out'];
			}
		
		}

		if ($price_in > 0 && $price_out > 0) {
			$marga = round(($price_out - $price_in) / $price_out * 100, 0);
		}
		
		
//		echo $offer_code."\n";
		
		$sheet->setCellValue('A'.$num, $offer_code);
		$sheet->setCellValue('B'.$num, $offer_name);
		$sheet->setCellValue('C'.$num, $offer_unit);
		$sheet->setCellValue('D'.$num, round($price_in, 2));
		$sheet->setCellValue('E'.$num, round($price_out, 2));
		$sheet->setCellValue('F'.$num, $marga);
		
		$offer_count_shop = 0;
		
		// Считаю количество продаж по магазинам
		$mysql_res2 = $GLOBALS['mysql_link'] -> query('SELECT st_good_id, SUM(st_qtty) 
				FROM br_store 
					WHERE 
						st_good_id = "'.$offer_id.'" 
						AND st_object_id != 7
						AND st_date = "'.$t_date.'";');	
		
		if ($row2 = mysqli_fetch_assoc($mysql_res2)) {
			$offer_count_shop = $row2['SUM(st_qtty)'];
		}
		
		
		$sheet->setCellValue('G'.$num, round($offer_count-$offer_count_shop, 4));
		
		$all_count = 0;
		$all_sum = 0;
		
		// Продажи скалада за 4 недели
		
		$prev_monday_t = time() - (date('N') +27) * 86400;
		$prev_sunday_t = $prev_monday_t + 6 * 86400;
	
		$mysql_res2 = $GLOBALS['mysql_link'] -> query('SELECT SUM(op_price_in * op_qtty), SUM(op_price_out * op_qtty), SUM(op_qtty) FROM br_operations 
			WHERE 
				op_good_id = "'.$offer_id.'" 
				AND op_operation_type = 8
				AND op_object_id = 7
				AND op_date >= "'.date('Y-m-d', $prev_monday_t ).'" 
				AND op_date <= "'.date('Y-m-d', $prev_sunday_t ).'" 
				ORDER BY op_user_real_time;');	
				
	
		$price_in = 0;
		$price_out = 0;

		if ($row2 = mysqli_fetch_assoc($mysql_res2)) {
			
			$price_in = $row2['SUM(op_price_in * op_qtty)'];
			$price_out = $row2['SUM(op_price_out * op_qtty)'];

			$all_count += $row2['SUM(op_qtty)'];
			$all_sum += $price_out - $price_in;

		}
		
		$sheet->setCellValue('H'.$num, @round($price_out-$price_in, 2));

		$sheet->setCellValue('I'.$num, @round($offer_count_shop, 0));

		$mysql_res2 = $GLOBALS['mysql_link'] -> query('SELECT SUM(op_price_in * op_qtty), SUM(op_price_out * op_qtty), SUM(op_qtty) FROM br_operations 
			WHERE 
				op_good_id = "'.$offer_id.'" 
				AND op_operation_type = 2 
				AND op_object_id != 7
				AND op_date >= "'.date('Y-m-d', $prev_monday_t ).'" 
				AND op_date <= "'.date('Y-m-d', $prev_sunday_t ).'" 
				ORDER BY op_user_real_time;');	
				
	
		$price_in = 0;
		$price_out = 0;

		if ($row2 = mysqli_fetch_assoc($mysql_res2)) {
			
			$price_in = $row2['SUM(op_price_in * op_qtty)'];
			$price_out = $row2['SUM(op_price_out * op_qtty)'];

			$all_count += $row2['SUM(op_qtty)'];
			$all_sum += $price_out - $price_in;

		}

		$sheet->setCellValue('J'.$num, round($price_out - $price_in, 0));
		
		
		$shops_count = 0;
		
		// Считаю количество магазинов
		$mysql_res2 = $GLOBALS['mysql_link'] -> query('SELECT st_object_id, SUM(st_qtty) 
				FROM br_store 
					WHERE 
						st_good_id = "'.$offer_id.'" 
						AND st_object_id != 7
						AND st_date = "'.$t_date.'" AND st_qtty > 0 GROUP BY st_object_id;');	
		
		while ($row2 = mysqli_fetch_assoc($mysql_res2)) {
			$tmp = $row2['SUM(st_qtty)'];
			
			if ($tmp > 0) $shops_count++;
		}
		
		
		$sheet->setCellValue('K'.$num, round($shops_count, 4));
		$sheet->setCellValue('L'.$num, $categ_name);

   	}

	$writer = new Xlsx($spreadsheet);
	//Сохраняем файл в текущей папке, в которой выполняется скрипт.
	//Чтобы указать другую папку для сохранения. 
	//Прописываем полный путь до папки и указываем имя файла
	$writer->save($_SERVER['DOCUMENT_ROOT'].'/br/cron/files/offers_sell_'.$t_date.'_stalev.xlsx');
    	
	echo '<a href="/br/cron/files/offers_sell_'.$t_date.'_stalev.xlsx">Скачать!</a>';	
?>