<?php

// Настройки окружения
$_SERVER['DOCUMENT_ROOT'] = '/home/oaapps/domains/apps.orderadmin.eu/public_html';

require_once $_SERVER['DOCUMENT_ROOT'] . "/br/db_config.php";
require $_SERVER['DOCUMENT_ROOT'] . '/br/vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

error_reporting(E_ALL);
ini_set('display_errors', 1);

/**
 * Класс для генерации отчёта продаж по товарам по всем магазинам.
 */
class OffersSellReportGenerator
{
    /** @var mysqli */
    protected $db;

    /** @var string */
    protected $docRoot;

    /** @var string */
    protected $dateFrom;

    /** @var string */
    protected $dateTo;

    /** @var array<string,string> */
    protected $categories = [];

    public function __construct(mysqli $db, string $docRoot, string $dateFrom, string $dateTo)
    {
        $this->db      = $db;
        $this->docRoot = rtrim($docRoot, '/');
        $this->dateFrom = $dateFrom;
        $this->dateTo   = $dateTo;

        $this->loadCategories();
    }

    /**
     * Загрузка категорий в память (один раз).
     */
    protected function loadCategories(): void
    {
        $sql = 'SELECT * FROM br_groups';
        $res = $this->db->query($sql);

        if (!$res) {
            throw new RuntimeException('Ошибка загрузки категорий: ' . $this->db->error);
        }

        while ($row = $res->fetch_assoc()) {
            $code = $row['gr_code'];
            $name = $row['gr_name'];
            $this->categories[$code] = $name;
        }
    }

    /**
     * Генерация отчётов для всех магазинов (sh_type = 0).
     */
    public function generateForAllShops(): void
    {
            $this->generateForShop(0, '');

/*
        $sql = 'SELECT * FROM br_shops WHERE `sh_type` = 0';
        $res = $this->db->query($sql);

        if (!$res) {
            throw new RuntimeException('Ошибка выборки магазинов: ' . $this->db->error);
        }

        while ($row = $res->fetch_assoc()) {
            $shopName = $row['sh_name'];
            $shopId   = (int)$row['sh_id_mi'];

            $this->generateForShop($shopId, $shopName);
        }
*/
    }

    /**
     * Генерация файла отчёта для одного магазина.
     *
     * @param int    $shopId
     * @param string $shopName
     */
    protected function generateForShop(int $shopId, string $shopName): void
    {
        // НОВАЯ книга для каждого магазина
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();

        $sheet->getPageMargins()
            ->setLeft(1)
            ->setRight(1)
            ->setTop(1)
            ->setBottom(1);

        $sheet->getColumnDimension('A')->setWidth(10);
        $sheet->getRowDimension('1')->setRowHeight(30);

        $sheet->getColumnDimension('C')->setWidth(30);
        $sheet->getColumnDimension('E')->setWidth(20);
        $sheet->getColumnDimension('B')->setWidth(50);
        $sheet->getColumnDimension('R')->setWidth(50);

        $sheet->getStyle('A1:R1')->getFont()->setBold(true);

        // Заливка шапки
        $this->fillHeaderColors($sheet);

        // ВАЖНО: счётчик строк СБРАСЫВАЕМ на 1 для КАЖДОГО магазина
        $num = 1;

        // Шапка
        $sheet->setCellValue('A'.$num, 'Код');
        $sheet->setCellValue('B'.$num, 'Товар');
        $sheet->setCellValue('C'.$num, 'Кухня');

        $sheet->setCellValue('D'.$num, 'Цена закупки');
        $sheet->setCellValue('E'.$num, 'Трансферная цена');
        $sheet->setCellValue('F'.$num, 'Продажная цена');

        $sheet->setCellValue('G'.$num, 'Кол-во закуплено');
        $sheet->setCellValue('H'.$num, 'Кол-во продано');
        $sheet->setCellValue('I'.$num, 'Кол-во списано');
        $sheet->setCellValue('J'.$num, 'Кол-во брак');

        $sheet->setCellValue('K'.$num, 'Группа');

        // Товары
        $sqlOffers = '
            SELECT 
                of_br_id,
                of_name,
                of_unit,
                gr_code,
                of_price_in,
                of_price_trans,
                of_price_out,
                of_producer,
                of_mi_id,
                of_kitchen_offer
            FROM 
                br_offers_old
                JOIN br_groups ON of_group_id = gr_id
            GROUP BY of_mi_id
            LIMIT 0, 10000
        ';

        $resOffers = $this->db->query($sqlOffers);
        if (!$resOffers) {
            throw new RuntimeException('Ошибка выборки товаров: ' . $this->db->error);
        }

        while ($row = $resOffers->fetch_assoc()) {

            $offerId        = $row['of_mi_id'];
            $offerCode      = $row['of_br_id'];
            $offerName      = $row['of_name'];
            $offerUnit      = $row['of_unit'];
            $categCode      = $row['gr_code'];
            $priceIn        = (float)$row['of_price_in'];
            $priceTrans     = (float)$row['of_price_trans'];
            $priceOut       = (float)$row['of_price_out'];
            $kitchenOffer   = $row['of_kitchen_offer'];

            $categName = $this->buildCategoryName($categCode);

            // Операции по товару в конкретном магазине
            $sqlOps = '
                SELECT 
                    op_operation_type,
                    SUM(op_qtty)                          AS sum_qtty,
                    SUM(op_price_out * op_qtty)           AS sum_price_out,
                    SUM(op_price_in  * op_qtty)           AS sum_price_in
                FROM br_operations 
                WHERE 
                    op_good_id = "'.$this->db->real_escape_string($offerId).'"
                    AND (
                        op_operation_type = 2 
                        OR op_operation_type = 34
                        OR op_operation_type = 11
                        OR op_operation_type = 3
                        OR op_operation_type = 1
                        OR op_operation_type = 7
                    )
                    AND op_date >= "'.$this->dateFrom.'"
                    AND op_date <= "'.$this->dateTo.'"
                GROUP BY op_operation_type
            ';
//                    AND op_object_id = "'.$this->db->real_escape_string($shopId).'"

            $resOps = $this->db->query($sqlOps);
            if (!$resOps) {
                throw new RuntimeException('Ошибка выборки операций: ' . $this->db->error);
            }

            $goodsSell   = 0.0;
            $goodsAccept = 0.0;
            $goodsBrak   = 0.0;
            $goodsSpis   = 0.0;

            while ($row2 = $resOps->fetch_assoc()) {

                $type    = (int)$row2['op_operation_type'];
                $sumQtty = (float)$row2['sum_qtty'];

                // Продажи
                if ($type === 2) {
                    $goodsSell = $sumQtty;

                    if ($sumQtty != 0.0) {
                        $priceIn  = (float)$row2['sum_price_in']  / $sumQtty;
                        $priceOut = (float)$row2['sum_price_out'] / $sumQtty;
                    }
                }

                // Возвраты (отнимаем)
                if ($type === 34) {
                    $goodsSell -= $sumQtty;
                }

                // Приемка товара
                if ($type === 1 || $type === 7) {
                    $goodsAccept += $sumQtty;
                }

                // Списание
                if ($type === 11) {
                    $goodsSpis += $sumQtty;
                }

                // Брак
                if ($type === 3) {
                    $goodsBrak += $sumQtty;
                }
            }

            $num++;

            // Запись строки в Excel
            $sheet->setCellValue('A'.$num, $offerCode);
            $sheet->setCellValue('B'.$num, $offerName);
            $sheet->setCellValue('C'.$num, $kitchenOffer);

            $sheet->setCellValue('D'.$num, str_replace('.', ',', round($priceIn, 2)));
            $sheet->setCellValue('E'.$num, str_replace('.', ',', round($priceTrans, 2)));
            $sheet->setCellValue('F'.$num, str_replace('.', ',', round($priceOut, 2)));

            $sheet->setCellValue('G'.$num, str_replace('.', ',', round($goodsAccept, 2)));
            $sheet->setCellValue('H'.$num, str_replace('.', ',', round($goodsSell, 2)));
            $sheet->setCellValue('I'.$num, str_replace('.', ',', round($goodsSpis, 2)));
            $sheet->setCellValue('J'.$num, str_replace('.', ',', round($goodsBrak, 2)));

            $sheet->setCellValue('K'.$num, $categName);
        }

        // Сохранение файла
        $filePath = $this->docRoot . '/br/cron/files/offers_sell_' .
            $this->dateFrom . '-' . $this->dateTo . '_' . $shopId . '2.xlsx';

        $writer = new Xlsx($spreadsheet);
        $writer->save($filePath);

        // Вывод ссылки
        echo 'https://apps.orderadmin.eu/br/cron/files/offers_sell_' .
            $this->dateFrom . '-' . $this->dateTo . '_' . $shopId . '2.xlsx - ' .
            $shopName . PHP_EOL;
    }

    /**
     * Красим шапку по образцу.
     */
    protected function fillHeaderColors(\PhpOffice\PhpSpreadsheet\Worksheet\Worksheet $sheet): void
    {
        $yellow = '#faff88';
        $green  = '#7bd673';
        $blue   = '#6bb0ff';

        foreach (['A1','B1','C1','D1','E1','F1','G1'] as $cell) {
            $sheet->getStyle($cell)
                ->getFill()
                ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
                ->getStartColor()
                ->setARGB($yellow);
        }

        foreach (['H1','I1','J1','K1'] as $cell) {
            $sheet->getStyle($cell)
                ->getFill()
                ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
                ->getStartColor()
                ->setARGB($green);
        }

        $sheet->getStyle('L1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB($blue);

        $sheet->getStyle('M1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB($green);

        $sheet->getStyle('N1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#faff88');
    }

    /**
     * Формирование человекочитаемого названия категории по коду.
     *
     * @param string $categCode
     * @return string
     */
    protected function buildCategoryName(string $categCode): string
    {
        $categName = '';

        $len = strlen($categCode);

        if ($len === 9) {
            $categName =
                ($this->categories[substr($categCode, 0, 3)] ?? '') . ' / ' .
                ($this->categories[substr($categCode, 0, 6)] ?? '') . ' / ' .
                ($this->categories[substr($categCode, 0, 9)] ?? '');
        } elseif ($len === 6) {
            $categName =
                ($this->categories[substr($categCode, 0, 3)] ?? '') . ' / ' .
                ($this->categories[substr($categCode, 0, 6)] ?? '');
        } elseif ($len === 3) {
            $categName = $this->categories[$categCode] ?? '';
        }

        return $categName;
    }
}

// ---------------- ЗАПУСК ----------------

$t_date1 = '2024-12-31';
$t_date2 = '2024-12-31';

$generator = new OffersSellReportGenerator(
    $GLOBALS['mysql_link'],
    $_SERVER['DOCUMENT_ROOT'],
    $t_date1,
    $t_date2
);

$generator->generateForAllShops();

