<?php
	
	$_SERVER['DOCUMENT_ROOT'] = '/home/oaapps/domains/apps.orderadmin.eu/public_html';

	require_once($_SERVER['DOCUMENT_ROOT']."/br/db_config.php");	
	require $_SERVER['DOCUMENT_ROOT'].'/br/vendor/autoload.php';

	use PhpOffice\PhpSpreadsheet\Spreadsheet;
	use PhpOffice\PhpSpreadsheet\Writer\Xlsx;   
	
	$arrContextOptions=array(
	    "ssl"=>array(
        "verify_peer"=>false,
        "verify_peer_name"=>false,
	    ),
	);  
	
	$page = 1;

	
	$t_date1 = '2024-12-01';
	$t_date2 = '2024-12-31';
	
	$num = 1;

	//Создаем экземпляр класса электронной таблицы
	$spreadsheet = new Spreadsheet();
	//Получаем текущий активный лист
	$sheet = $spreadsheet->getActiveSheet();
	$sheet->getPageMargins()
	    ->setLeft(1)
	    ->setRight(1)
	    ->setTop(1)
	    ->setBottom(1)
	;

	$sheet->getColumnDimension('A')->setWidth(10);
	$sheet->getRowDimension('1')->setRowHeight(30);

	$sheet->getColumnDimension('C')->setWidth(30);
	$sheet->getColumnDimension('E')->setWidth(20);
	$sheet->getColumnDimension('B')->setWidth(50);
	$sheet->getColumnDimension('R')->setWidth(50);

	$sheet->getStyle('A1:R1')->getFont()->setBold(true);

	$sheet->getStyle('A1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#faff88');
	$sheet->getStyle('B1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#faff88');
	$sheet->getStyle('C1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#faff88');
	$sheet->getStyle('D1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#faff88');
	$sheet->getStyle('E1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#faff88');
	$sheet->getStyle('F1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#faff88');
	$sheet->getStyle('G1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#faff88');

	$sheet->getStyle('H1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#7bd673');
	$sheet->getStyle('I1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#7bd673');
	$sheet->getStyle('J1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#7bd673');
	$sheet->getStyle('K1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#7bd673');

	$sheet->getStyle('L1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#6bb0ff');

	$sheet->getStyle('M1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#7bd673');
	$sheet->getStyle('N1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#faff88');

	// Записываем в ячейку A1 данные
	$sheet->setCellValue('A'.$num, 'Код');
	$sheet->setCellValue('B'.$num, 'Товар');
	$sheet->setCellValue('C'.$num, 'Кухня');
	
	$sheet->setCellValue('D'.$num, 'Цена закупки');
	$sheet->setCellValue('E'.$num, 'Трансферная цена');
	$sheet->setCellValue('F'.$num, 'Продажная цена');

	$sheet->setCellValue('G'.$num, 'Кол-во закуплено');	
	$sheet->setCellValue('H'.$num, 'Кол-во продано');
	$sheet->setCellValue('I'.$num, 'Кол-во списано');
	$sheet->setCellValue('J'.$num, 'Кол-во брак');

	$sheet->setCellValue('K'.$num, 'Группа');
	
	$ar_categ = [];
	
	$mysql_res = $GLOBALS['mysql_link'] -> query('SELECT * FROM br_groups;');	
	
	while ($row = mysqli_fetch_assoc($mysql_res)) {
		
		$code = $row['gr_code'];
		$name = $row['gr_name'];

		$ar_categ[$code] = $name;

	}

	$ar_shops = [];
	
	$mysql_res = $GLOBALS['mysql_link'] -> query('SELECT * FROM br_shops;');	
	
	while ($row = mysqli_fetch_assoc($mysql_res)) {
		
		$ar_shops[$row['sh_id_mi']] = $row['sh_name'];

	}

	$mysql_res = $GLOBALS['mysql_link'] -> query('SELECT of_br_id, of_name, of_unit, gr_code, of_price_in, of_price_trans, of_price_out, of_producer, of_mi_id, of_kitchen_offer
			FROM 
				br_offers, br_groups 
				WHERE 
					of_group_id = gr_id 
					GROUP BY of_mi_id LIMIT 0, 10000;');	
					
	while ($row = mysqli_fetch_assoc($mysql_res)) {
		
		$categ_code = '';
		
		$offer_id 		= $row['of_mi_id'];
		$offer_code 	= $row['of_br_id'];
		$offer_name 	= $row['of_name'];
		$offer_unit 	= $row['of_unit'];
		$categ_code 	= $row['gr_code'];
		$price_in 		= $row['of_price_in'];
		$price_trans 	= $row['of_price_trans'];
		$price_out 		= $row['of_price_out'];

		$of_kitchen_offer 		= $row['of_kitchen_offer'];
		
		if (strlen($categ_code) == 9) $categ_name = $ar_categ[substr($categ_code, 0, 3)].' / '.$ar_categ[substr($categ_code, 0, 6)].' / '.$ar_categ[substr($categ_code, 0, 9)];
		if (strlen($categ_code) == 6) $categ_name = $ar_categ[substr($categ_code, 0, 3)].' / '.$ar_categ[substr($categ_code, 0, 6)];
		if (strlen($categ_code) == 3) $categ_name = $ar_categ[$categ_code];
		
		$mysql_res2 = $GLOBALS['mysql_link'] -> query('SELECT 
																op_operation_type,
																sum(op_qtty), 
																sum(op_price_out*op_qtty), 
																sum(op_price_in*op_qtty)
															
															FROM `br_operations` 
															WHERE 
																op_good_id = "'.$offer_id.'" 
																AND (
																	op_operation_type = 2 
																	OR op_operation_type = 34
																	OR op_operation_type = 11
																	OR op_operation_type = 3
																	OR op_operation_type = 1
																	OR op_operation_type = 7
																)
																AND op_object_id != 7
																AND op_date >= "'.$t_date1.'" 
																AND op_date <= "'.$t_date2.'"
																
															GROUP BY op_operation_type;
																');	
																
		$goods_sell = 0;
		$goods_accept = 0;
		$goods_brak = 0;
		$goods_spis = 0;

		while ($row2 = mysqli_fetch_assoc($mysql_res2)) {

			$type = $row2['op_operation_type'];
			
			if ($type == 2) {
				
				$goods_sell = $row2['sum(op_qtty)'];
				
				$price_in = $row2['sum(op_price_in*op_qtty)'] / $row2['sum(op_qtty)'];
				$price_out = $row2['sum(op_price_out*op_qtty)'] / $row2['sum(op_qtty)'];
				
			}

			// Возвраты
			if ($type == 34) {
				
				$goods_sell -= $row2['sum(op_qtty)'];
				
			}
				

			// Приемка товара
			if ($type == 1 || $type == 7) {
				
				$goods_accept += $row2['sum(op_qtty)'];
				
			}
				
			// Списание
			if ($type == 11) {
				
				$goods_spis += $row2['sum(op_qtty)'];
				
			}
				
			// Брак
			if ($type == 3) {
				
				$goods_brak += $row2['sum(op_qtty)'];
				
			}
				
			
		}

		$num++;
		
		$sheet->setCellValue('A'.$num, $offer_code);
		$sheet->setCellValue('B'.$num, $offer_name);
		$sheet->setCellValue('C'.$num, $of_kitchen_offer);
		
		$sheet->setCellValue('D'.$num, str_replace('.', ',', round($price_in, 2)));
		$sheet->setCellValue('E'.$num, str_replace('.', ',', round($price_trans, 2)));
		$sheet->setCellValue('F'.$num, str_replace('.', ',', round($price_out, 2)));
		
		$sheet->setCellValue('G'.$num, str_replace('.', ',', round($goods_accept, 2)));
		$sheet->setCellValue('H'.$num, str_replace('.', ',', round($goods_sell, 2)));
		$sheet->setCellValue('I'.$num, str_replace('.', ',', round($goods_spis, 2)));
		$sheet->setCellValue('J'.$num, str_replace('.', ',', round($goods_brak, 2)));
		
		$sheet->setCellValue('K'.$num, $categ_name);
		

   	}

	$writer = new Xlsx($spreadsheet);
	//Сохраняем файл в текущей папке, в которой выполняется скрипт.
	//Чтобы указать другую папку для сохранения. 
	//Прописываем полный путь до папки и указываем имя файла
	$writer->save($_SERVER['DOCUMENT_ROOT'].'/br/cron/files/offers_sell_'.$t_date1.'-'.$t_date2.'_dima.xlsx');
    	
	echo '<a href="/br/cron/files/offers_sell_'.$t_date1.'-'.$t_date2.'_dima.xlsx">Скачать!</a>';	
?>