<?php
	
	$_SERVER['DOCUMENT_ROOT'] = '/home/oaapps/domains/apps.orderadmin.eu/public_html';

	require_once($_SERVER['DOCUMENT_ROOT']."/br/db_config.php");	
	require $_SERVER['DOCUMENT_ROOT'].'/br/vendor/autoload.php';

	use PhpOffice\PhpSpreadsheet\Spreadsheet;
	use PhpOffice\PhpSpreadsheet\Writer\Xlsx;   
	
	$arrContextOptions=array(
	    "ssl"=>array(
        "verify_peer"=>false,
        "verify_peer_name"=>false,
	    ),
	);  
	
	$arPartners = [];
	$page = 1;

	for($page = 1; $page < 1000; $page++) {
		
		$arPartners[0] = 'Я ХЗ кто это!!';
		
		$file = file_get_contents($GLOBALS['MI_HOST'].'/Partners?page='.$page, false, stream_context_create($arrContextOptions));
		
		$file_json = json_decode($file);
		
		$num = 0;
		
		foreach($file_json as $t_json) {
			
			$num++;
	
			$arPartners[$t_json->id] = $t_json->company;
	
		}
		
		if ($num == 0) break;
	
	}
	
	$t_date = date('Y-m-d', time());

	$num = 1;

	//Создаем экземпляр класса электронной таблицы
	$spreadsheet = new Spreadsheet();
	//Получаем текущий активный лист
	$sheet = $spreadsheet->getActiveSheet();
	$sheet->getPageMargins()
	    ->setLeft(1)
	    ->setRight(1)
	    ->setTop(1)
	    ->setBottom(1)
	;

	$sheet->getColumnDimension('A')->setWidth(10);
	$sheet->getRowDimension('1')->setRowHeight(30);

	$sheet->getColumnDimension('C')->setWidth(30);
	$sheet->getColumnDimension('E')->setWidth(20);
	$sheet->getColumnDimension('B')->setWidth(50);
	$sheet->getColumnDimension('R')->setWidth(50);

	$sheet->getStyle('A1:R1')->getFont()->setBold(true);

	$sheet->getStyle('A1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#faff88');
	$sheet->getStyle('B1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#faff88');
	$sheet->getStyle('C1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#faff88');
	$sheet->getStyle('D1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#faff88');
	$sheet->getStyle('E1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#faff88');
	$sheet->getStyle('F1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#faff88');
	$sheet->getStyle('G1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#faff88');

	$sheet->getStyle('H1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#7bd673');
	$sheet->getStyle('I1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#7bd673');
	$sheet->getStyle('J1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#7bd673');
	$sheet->getStyle('K1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#7bd673');

	$sheet->getStyle('L1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#6bb0ff');

	$sheet->getStyle('M1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#7bd673');
	$sheet->getStyle('N1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#faff88');

	// Записываем в ячейку A1 данные
	$sheet->setCellValue('A'.$num, 'Код');
	$sheet->setCellValue('B'.$num, 'Товар');

	$sheet->setCellValue('C'.$num, 'Группа');
	$sheet->setCellValue('D'.$num, 'Партнер');
	$sheet->setCellValue('E'.$num, 'Объект');
	$sheet->setCellValue('F'.$num, 'Количество');
	$sheet->setCellValue('G'.$num, 'Продажи, сумма');	
	$sheet->setCellValue('H'.$num, 'Сумма НДС');
	
	$sheet->setCellValue('I'.$num, 'Приходная ст-сть');
	$sheet->setCellValue('J'.$num, 'Возврат сумма');
	$sheet->setCellValue('K'.$num, 'Возвр НДС');
	$sheet->setCellValue('L'.$num, 'Брак (шт)');
	$sheet->setCellValue('M'.$num, 'Списание (шт)');
	
	$ar_categ = [];
	
	$mysql_res = $GLOBALS['mysql_link'] -> query('SELECT * FROM br_groups;');	
	
	while ($row = mysqli_fetch_assoc($mysql_res)) {
		
		$code = $row['gr_code'];
		$name = $row['gr_name'];

		$ar_categ[$code] = $name;

	}

	$ar_shops = [];
	
	$mysql_res = $GLOBALS['mysql_link'] -> query('SELECT * FROM br_shops;');	
	
	while ($row = mysqli_fetch_assoc($mysql_res)) {
		
		$ar_shops[$row['sh_id_mi']] = $row['sh_name'];

	}

	$t_date1 = '2024-07-01';
	$t_date2 = '2024-07-31';

	$mysql_res = $GLOBALS['mysql_link'] -> query('SELECT of_br_id, of_name, of_unit, gr_code, of_price_in, of_price_out, of_producer, of_mi_id 
			FROM 
				br_offers, br_groups 
				WHERE 
					of_group_id = gr_id 
						
					GROUP BY of_mi_id LIMIT 0, 10000;');	

	while ($row = mysqli_fetch_assoc($mysql_res)) {
		
		$categ_code = '';
		
		$offer_id = $row['of_mi_id'];
		$offer_code = $row['of_br_id'];
		$offer_name = $row['of_name'];
		$offer_unit = $row['of_unit'];
		$categ_code = $row['gr_code'];
		$price_in = $row['of_price_in'];
		$price_out = $row['of_price_out'];
		$offer_producer = $row['of_producer'];
		
		if (strlen($categ_code) == 9) $categ_name = $ar_categ[substr($categ_code, 0, 3)].' / '.$ar_categ[substr($categ_code, 0, 6)].' / '.$ar_categ[substr($categ_code, 0, 9)];
		if (strlen($categ_code) == 6) $categ_name = $ar_categ[substr($categ_code, 0, 3)].' / '.$ar_categ[substr($categ_code, 0, 6)];
		if (strlen($categ_code) == 3) $categ_name = $ar_categ[$categ_code];
		
		$mysql_res2 = $GLOBALS['mysql_link'] -> query('SELECT 
																op_object_id, 
																op_partner_id, 
																sum(op_price_out), 
																sum(op_qtty), 
																sum(op_price_out*op_qtty), 
																sum(op_vat_out*op_qtty), 
																sum(op_price_in*op_qtty), 
																op_price_in
															
															FROM `br_operations` 
															WHERE 
																op_good_id = "'.$offer_id.'" 
																AND (
																	op_operation_type = 2 
																	OR op_operation_type = 34
																	OR op_operation_type = 11
																)
																AND op_date >= "'.$t_date1.'" 
																AND op_date <= "'.$t_date2.'" 
															GROUP BY op_object_id, op_partner_id;');			

		while ($row2 = mysqli_fetch_assoc($mysql_res2)) {

			$num++;

			$partner_id = $row2['op_partner_id'];
			$object_id = $row2['op_object_id'];
				
			// Сумма возвратов
			$mysql_res3 = $GLOBALS['mysql_link'] -> query('SELECT 
																	sum(op_qtty), 
																	sum(op_price_out*op_qtty),
																	sum(op_vat_out*op_qtty),
																	sum(op_price_in*op_qtty)
																	
																FROM `br_operations` 
																WHERE 
																	op_good_id = "'.$offer_id.'" 
																	AND op_object_id = "'.$object_id.'" 
																	AND op_partner_id = "'.$partner_id.'" 
																	AND op_operation_type = 2 
																	AND op_date >= "'.$t_date1.'" 
																	AND op_date <= "'.$t_date2.'" 
																;');	
																		
			$countSell = 0;
			$sum_price_out = 0;
			$sum_price_out_vat = 0;
			$sum_price_in = 0;

			if ($row3 = mysqli_fetch_assoc($mysql_res3)) {

				$countSell = $row3['sum(op_qtty)'];
				$sum_price_out = $row3['sum(op_price_out*op_qtty)'];
				$sum_price_out_vat = $row3['sum(op_vat_out*op_qtty)'];
				$sum_price_in = $row3['sum(op_price_in*op_qtty)'];

			}
						
			$sheet->setCellValue('A'.$num, $offer_code);
			$sheet->setCellValue('B'.$num, $offer_name);
			$sheet->setCellValue('C'.$num, $categ_name);
			$sheet->setCellValue('D'.$num, $arPartners[$partner_id]);
			$sheet->setCellValue('E'.$num, $ar_shops[$object_id]);
			$sheet->setCellValue('F'.$num, round($countSell, 2));
			$sheet->setCellValue('G'.$num, round($sum_price_out, 2));
			$sheet->setCellValue('H'.$num, round($sum_price_out_vat, 2));
			$sheet->setCellValue('I'.$num, round($sum_price_in, 2));
			
			// Сумма возвратов
			$mysql_res3 = $GLOBALS['mysql_link'] -> query('SELECT 
																	sum(op_price_out*op_qtty),
																	sum(op_vat_out*op_qtty)
																	
																FROM `br_operations` 
																WHERE 
																	op_good_id = "'.$offer_id.'" 
																	AND op_object_id = "'.$object_id.'" 
																	AND op_partner_id = "'.$partner_id.'" 
																	AND op_operation_type = 34 
																	AND op_date >= "'.$t_date1.'" 
																	AND op_date <= "'.$t_date2.'" 
																;');			
			if ($row3 = mysqli_fetch_assoc($mysql_res3)) {

				$sheet->setCellValue('J'.(string)$num, round($row3['sum(op_price_out*op_qtty)'], 2));
				$sheet->setCellValue('K'.(string)$num, round($row3['sum(op_vat_out*op_qtty)'], 2));

			}
			
			// Сумма брака
			$mysql_res3 = $GLOBALS['mysql_link'] -> query('SELECT 
																	sum(op_qtty)
																	
																FROM `br_operations` 
																WHERE 
																	op_good_id = "'.$offer_id.'" 
																	AND op_object_id = "'.$object_id.'" 
																	AND op_partner_id = "'.$partner_id.'" 
																	AND op_operation_type = 3
																	AND op_date >= "'.$t_date1.'" 
																	AND op_date <= "'.$t_date2.'" 
																;');			
			if ($row3 = mysqli_fetch_assoc($mysql_res3)) {

				$sheet->setCellValue('L'.(string)$num, round($row3['sum(op_qtty)'], 2));

			}
			
			// Сумма списаний
			$mysql_res3 = $GLOBALS['mysql_link'] -> query('SELECT 
																	sum(op_qtty)
																	
																FROM `br_operations` 
																WHERE 
																	op_good_id = "'.$offer_id.'" 
																	AND op_object_id = "'.$object_id.'" 
																	AND op_partner_id = "'.$partner_id.'" 
																	AND op_operation_type = 11
																	AND op_date >= "'.$t_date1.'" 
																	AND op_date <= "'.$t_date2.'" 
																;');			
			if ($row3 = mysqli_fetch_assoc($mysql_res3)) {

				$sheet->setCellValue('M'.(string)$num, round($row3['sum(op_qtty)'], 2));

			}
			
		}
		
		

   	}

	$writer = new Xlsx($spreadsheet);
	//Сохраняем файл в текущей папке, в которой выполняется скрипт.
	//Чтобы указать другую папку для сохранения. 
	//Прописываем полный путь до папки и указываем имя файла
	$writer->save($_SERVER['DOCUMENT_ROOT'].'/br/cron/files/offers_sell_'.$t_date.'_artem.xlsx');
    	
	echo '<a href="/br/cron/files/offers_sell_'.$t_date.'_artem.xlsx">Скачать!</a>';	
?>