<?php
	
	$_SERVER['DOCUMENT_ROOT'] = '/home/oaapps/domains/apps.orderadmin.eu/public_html';

	require_once($_SERVER['DOCUMENT_ROOT']."/br/db_config.php");	
	require $_SERVER['DOCUMENT_ROOT'].'/br/vendor/autoload.php';

	use PhpOffice\PhpSpreadsheet\Spreadsheet;
	use PhpOffice\PhpSpreadsheet\Writer\Xlsx;   
	
	$t_date = date('Y-m-d', time());

	$num = 1;

	//Создаем экземпляр класса электронной таблицы
	$spreadsheet = new Spreadsheet();
	//Получаем текущий активный лист
	$sheet = $spreadsheet->getActiveSheet();
	$sheet->getPageMargins()
	    ->setLeft(1)
	    ->setRight(1)
	    ->setTop(1)
	    ->setBottom(1)
	;

	$sheet->getColumnDimension('A')->setWidth(10);
	$sheet->getRowDimension('1')->setRowHeight(30);

	$sheet->getColumnDimension('B')->setWidth(50);

	$sheet->getStyle('A1:R1')->getFont()->setBold(true);

	$sheet->getStyle('A1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#faff88');
	$sheet->getStyle('B1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#faff88');
	$sheet->getStyle('C1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#faff88');
	$sheet->getStyle('D1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#faff88');
	$sheet->getStyle('E1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#faff88');
	$sheet->getStyle('F1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#faff88');
	$sheet->getStyle('G1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#faff88');

	$sheet->getStyle('H1')
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()
            ->setARGB('#7bd673');

	// Записываем в ячейку A1 данные
	$sheet->setCellValue('A'.$num, 'Код');
	$sheet->setCellValue('B'.$num, 'Товар');

	$sheet->setCellValue('C'.$num, 'Срок годности');
	$sheet->setCellValue('D'.$num, 'Осталось дней');
	$sheet->setCellValue('E'.$num, 'Продажи за неделю');
	$sheet->setCellValue('F'.$num, 'Остаток на складе');	
	$sheet->setCellValue('G'.$num, 'Остаток в магазинах');
	
	$sheet->setCellValue('H'.$num, 'Оставшиеся сроки годности');
	
	$mysql_res = $GLOBALS['mysql_link'] -> query('SELECT st_good_id, of_br_id, of_name, of_unit, SUM(st_qtty), SUM(st_price), of_price_in, of_price_out, of_producer 
			FROM br_store, br_offers 
				WHERE 
					st_good_id = of_mi_id 
					AND st_date = "'.$t_date.'" 
					AND of_deleted = 0 
						
					GROUP BY st_good_id ORDER BY SUM(st_qtty) DESC LIMIT 0, 10000;');	

	while ($row = mysqli_fetch_assoc($mysql_res)) {
		
		$num++;
		
		$categ_code = '';
		$offer_exp_date = '';
		
		$offer_id = $row['st_good_id'];
		$offer_code = $row['of_br_id'];
		$offer_name = $row['of_name'];
		$offer_unit = $row['of_unit'];
		$offer_count = $row['SUM(st_qtty)'];
		$price_in = $row['of_price_in'];
		$price_out = $row['of_price_out'];

		// Первая неделя

		$prev_monday_t = time() - (date('N') +6) * 86400;
		$prev_sunday_t = $prev_monday_t + 6 * 86400;
	
		$mysql_res2 = $GLOBALS['mysql_link'] -> query('SELECT SUM(op_price_in * op_qtty), SUM(op_price_out * op_qtty), SUM(op_qtty) FROM br_operations 
			WHERE 
				op_good_id = "'.$offer_id.'" 
				AND op_operation_type = 2 
				AND op_date >= "'.date('Y-m-d', $prev_monday_t ).'" 
				AND op_date <= "'.date('Y-m-d', $prev_sunday_t ).'" 
				ORDER BY op_user_real_time;');	
		
		$price_in = 0;
		$price_out = 0;
		$all_sum = 0;
		$all_count = 0;
		$min_days = 0;

		if ($row2 = mysqli_fetch_assoc($mysql_res2)) {
			
			$price_in = $row2['SUM(op_price_in * op_qtty)'];
			$price_out = $row2['SUM(op_price_out * op_qtty)'];

			$all_count += $row2['SUM(op_qtty)'];
			$all_sum += $price_out - $price_in;

		}
		
		$arExpDate = [];

		$resultQueryOffersList = $GLOBALS['mysql_link'] -> query('SELECT * FROM br_acceptance, br_acceptance_offers WHERE ac_id = ao_id_acceptance AND ac_type = 2 AND ac_shop_id = 8 
			AND oa_exception_date >= "'.date('Y-m-d', time()).'"
			AND ao_id_offer_code = "'.$offer_code.'"
				
			 	ORDER BY oa_exception_date ASC;');

		$tNum = 0;
		while ($rowOffer = mysqli_fetch_assoc($resultQueryOffersList)) {
			
			if ($tNum==0 || ($arExpDate[$tNum] != $arExpDate[$tNum-1])) {
				$arExpDate[$tNum] = $rowOffer['oa_exception_date'];
				$tNum++;
			}
	
		}
		
		$offer_count_shop = 0;

		// Считаю количество продаж по магазинам
		$mysql_res2 = $GLOBALS['mysql_link'] -> query('SELECT st_good_id, SUM(st_qtty) 
				FROM br_store 
					WHERE 
						st_good_id = "'.$offer_id.'" 
						AND st_object_id != 7
						AND st_date = "'.$t_date.'";');	
		
		if ($row2 = mysqli_fetch_assoc($mysql_res2)) {
			$offer_count_shop = $row2['SUM(st_qtty)'];
		}


		if (@strlen($arExpDate[0]) == 10) {
			$date1 = time();
			$date2 = strtotime($arExpDate[0]);
			$min_days = ABS($date2 - $date1) / (60*60*24);
		}
		
		
//		echo $offer_code."\n";
		
		$sheet->setCellValue('A'.$num, $offer_code);
		$sheet->setCellValue('B'.$num, $offer_name);
		$sheet->setCellValue('C'.$num, @$arExpDate[0]);
		$sheet->setCellValue('D'.$num, @round($min_days));
		$sheet->setCellValue('E'.$num, @round($all_sum, 2));
		$sheet->setCellValue('F'.$num, @round($offer_count - $offer_count_shop, 2));
		$sheet->setCellValue('G'.$num, @round($offer_count_shop, 2));
		
		$arRows = ['H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'V', 'W'];
		
		$tNum = -1;
		foreach($arExpDate as $currentExpDate) {
			
			if ($tNum>=0) {
				
				$sheet->setCellValue($arRows[$tNum].$num, $currentExpDate);
			
			}
			$tNum++;
			
			if ($tNum > 10) break;
		}
		

   	}

	$writer = new Xlsx($spreadsheet);
	//Сохраняем файл в текущей папке, в которой выполняется скрипт.
	//Чтобы указать другую папку для сохранения. 
	//Прописываем полный путь до папки и указываем имя файла
	$writer->save($_SERVER['DOCUMENT_ROOT'].'/br/cron/files/offers_sell_'.$t_date.'_exp.xlsx');
    	
	echo '<a href="/br/cron/files/offers_sell_'.$t_date.'_exp.xlsx">Скачать!</a>';
		
?>